function [M,xt,Ep]=discretisation(x,Epc)
% DISCRETISATION transforme une nergie potentielle continue,
%   dpendente de la variable de position x, en une nergie
%   potentielle discrte constitue d'une succession de marches
%   d'nergie potentielle.
%   [M,xt,Ep]=DISCRETISATION(x,Epc)
%       >> x    = Variable de position;
%       >> Epc  = Energie potentielle "continue";
%       << M    = Nom d'une marche d'nergie potentielle;
%       << xt   = Position d'une marche (transition);
%       << Ep   = Energie potentielle discrte.
%
%   Olivier Pujol : septembre 2013
%
%% Nom des marches constituant l'nergie potentielle dicrtise

M=cell(1,(length(x)-1));
for n=1:length(x)-1
    M{n}=['M',num2str(n)];
end
%
%% Discrtisation

[xs,Eps]=stairs(x,Epc);     % Discrtisation

% Positions des marches M
xs=xs-0.5*(x(2)-x(1));      % On dcale xs de la moiti du pas selon Ox
xt=xs(2.*(1:length(x)-1));  % On slectionne dans xs une valeur sur 2  partir de xs(2)

% Hauteur des marches M
Ep=Eps(2.*(1:length(x)-1)); % Mme chose pour Eps afin de rcuprer la hauteur des marches M.

% On doit, en outre, imposer l'nergie potentielle de sortie. 
% Pour cela, on la fixe  la dernire valeur de Epc 
Ep(length(x))=Epc(end);
%
%% Reprsentation graphique

figure
plot(xs,Eps,'r',x,Epc,'b');
axis tight;
grid on;
box on;
set(gca,'Xminortick','on','Yminortick','on');
xlabel('x (nm)');
ylabel('Energie (eV)');
title('Energie potentielle');
%
return;